let tableColaboradores;
let rowTable = ""; 
let divLoading = document.querySelector("#divLoading");
document.addEventListener('DOMContentLoaded', function(){
    tableColaboradores = $('#tableColaboradores').dataTable( {
        "aProcessing":true,
        "aServerSide":true,
        "language": {
            "decimal": "",
        "emptyTable": "No hay información",
        "info": "Mostrando _START_ a _END_ de _TOTAL_ Registros",
        "infoEmpty": "Mostrando 0 to 0 of 0 Registros",
        "infoFiltered": "(Filtrado de _MAX_ total registros)",
        "infoPostFix": "",
        "thousands": ",",
        "lengthMenu": "Mostrar _MENU_ Registros",
        "loadingRecords": "Cargando...",
        "processing": "Procesando...",
        "search": "Buscar:",
        "zeroRecords": "Sin resultados encontrados",
        "paginate": {
            "first": "Primero",
            "last": "Último",
            "next": "Siguiente",
            "previous": "Anterior"
        }
        },
        "ajax":{
            "url": " "+base_url+"/Colaboradores/getColaboradores",
            "dataSrc":""
        },
        "columns":[            
            {"data":"nombre_empleado"},
            {"data":"apellido_empleado"},
            {"data":"email_empleado"},
            {"data":"movil_empleado"},
            {"data":"nombrecargo"},            
            {"data":"options"}
        ],
        'dom': 'lBfrtip',
        'buttons': [
            {
                "extend": "copyHtml5",
                "text": "<i class='far fa-copy'></i> Copiar",
                "titleAttr":"Copiar",
                "className": "btn btn-secondary"
            },{
                "extend": "excelHtml5",
                "text": "<i class='fas fa-file-excel'></i> Excel",
                "titleAttr":"Esportar a Excel",
                "className": "btn btn-success"
            },{
                "extend": "pdfHtml5",
                "text": "<i class='fas fa-file-pdf'></i> PDF",
                "titleAttr":"Esportar a PDF",
                "className": "btn btn-danger"
            },{
                "extend": "csvHtml5",
                "text": "<i class='fas fa-file-csv'></i> CSV",
                "titleAttr":"Esportar a CSV",
                "className": "btn btn-info"
            }
        ],
        "resonsieve":"true",
        "bDestroy": true,
        "iDisplayLength": 10,
        "order":[[0,"asc"]]  
    });

    if(document.querySelector("#formColaborador")){
        let formColaborador = document.querySelector("#formColaborador");
        formColaborador.onsubmit = function(e) {
            e.preventDefault();            
            let strNombre = document.querySelector('#txtNombre').value;
            let strApellido = document.querySelector('#txtApellido').value;
            let strEmail = document.querySelector('#txtEmail').value;
            let intTelefono = document.querySelector('#txtTelefono').value;
            let intIdCargo = document.querySelector('#listCargoid').value;            
            

            if(strApellido == '' || strNombre == '' || strEmail == '' || intTelefono == '' || intIdCargo  == '0')
            {
                swal("Atención", "Todos los campos son obligatorios." , "error");
                return false;
            }

            let elementsValid = document.getElementsByClassName("valid");
            for (let i = 0; i < elementsValid.length; i++) { 
                if(elementsValid[i].classList.contains('is-invalid')) { 
                    swal("Atención", "Por favor verifique los campos en rojo." , "error");
                    return false;
                } 
            } 
            divLoading.style.display = "flex";
            let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
            let ajaxUrl = base_url+'/Colaboradores/setColaborador'; 
            let formData = new FormData(formColaborador);
            request.open("POST",ajaxUrl,true);
            request.send(formData);
            request.onreadystatechange = function(){
                if(request.readyState == 4 && request.status == 200){
                    let objData = JSON.parse(request.responseText);
                    
                        if(rowTable == ""){
                            tableColaboradores.api().ajax.reload();
                        }else{                            
                            rowTable.cells[0].textContent = strNombre;
                            rowTable.cells[1].textContent = strApellido;
                            rowTable.cells[2].textContent = strEmail;
                            rowTable.cells[3].textContent = intTelefono;
                            rowTable.cells[4].textContent = document.querySelector("#listCargoid").selectedOptions[0].text;                            
                            rowTable = ""; 
                        }
                        $('#modalFormColaborador').modal("hide");
                        formColaborador.reset();
                        swal("Colaboradores", objData.msg ,"success");
                    
                }
                divLoading.style.display = "none";
                return false;
            }
        }
    }  
}, false);


window.addEventListener('load', function() {
        fntCargos();
}, false);

function fntCargos(){
    if(document.querySelector('#listCargoid')){
        let ajaxUrl = base_url+'/Cargos/getSelectCargos';
        let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
        request.open("GET",ajaxUrl,true);
        request.send();
        request.onreadystatechange = function(){
            if(request.readyState == 4 && request.status == 200){
                document.querySelector('#listCargoid').innerHTML = request.responseText;
                $('#listCargoid').selectpicker('render');
            }
        }
    }
}

function fntViewColaborador(idempleado){
    let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
    let ajaxUrl = base_url+'/Colaboradores/getColaborador/'+idempleado;
    request.open("GET",ajaxUrl,true);
    request.send();
    request.onreadystatechange = function(){
        if(request.readyState == 4 && request.status == 200){
            let objData = JSON.parse(request.responseText);

            
                document.querySelector("#celNombre").innerHTML = objData.data.nombre;
                document.querySelector("#celApellido").innerHTML = objData.data.apellido;
                document.querySelector("#celTelefono").innerHTML = objData.data.telefono;
                document.querySelector("#celEmail").innerHTML = objData.data.email;               
                document.querySelector("#celNombreCargo").innerHTML = objData.data.nombrecargo;
                
                $('#modalViewColaborador').modal('show');
            
        }
    }
}

function fntEditColaborador(element,idempleado){
    rowTable = element.parentNode.parentNode.parentNode; 
    document.querySelector('#titleModal').innerHTML ="Actualizar Colaborador";
    document.querySelector('.modal-header').classList.replace("headerRegister", "headerUpdate");
    document.querySelector('#btnActionForm').classList.replace("btn-primary", "btn-info");
    document.querySelector('#btnText').innerHTML ="Actualizar";
    let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
    let ajaxUrl = base_url+'/Colaboradores/getColaborador/'+idempleado;
    request.open("GET",ajaxUrl,true);
    request.send();
    request.onreadystatechange = function(){

        if(request.readyState == 4 && request.status == 200){

            let objData = JSON.parse(request.responseText);

            if(objData.status)
            {
                document.querySelector("#idColaborador").value = objData.data.id_empleado;                
                document.querySelector("#txtNombre").value = objData.data.nombre_empleado;
                document.querySelector("#txtApellido").value = objData.data.apellido_empleado;
                document.querySelector("#txtTelefono").value = objData.data.movil_empleado;
                document.querySelector("#txtEmail").value = objData.data.email_empleado;
                document.querySelector("#listCargoid").value =objData.data.id_cargo_empleado;                
                $('#listCargoid').selectpicker('render');                
            }
        }
    
        $('#modalFormColaborador').modal('show');
    }
}

function fntDelColaborador(idempleado){
    swal({
        title: "Eliminar Colaborador",
        text: "¿Realmente quiere eliminar el Colaborador?",
        type: "warning",
        showCancelButton: true,
        confirmButtonText: "Si, eliminar!",
        cancelButtonText: "No, cancelar!",
        closeOnConfirm: false,
        closeOnCancel: true
    }, function(isConfirm) {
        
        if (isConfirm) 
        {
            let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
            let ajaxUrl = base_url+'/Colaboradores/delColaborador';
            let strData = "idColaborador="+idempleado;
            request.open("POST",ajaxUrl,true);
            request.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
            request.send(strData);
            request.onreadystatechange = function(){
                if(request.readyState == 4 && request.status == 200){
                    let objData = JSON.parse(request.responseText);
                    if(objData.status)
                    {
                        swal("Eliminar!", objData.msg , "success");
                        tableColaboradores.api().ajax.reload();
                    }else{
                        swal("Atención!", objData.msg , "error");
                    }
                }
            }
        }

    });

}


function openModal()
{
    rowTable = "";
    document.querySelector('#idColaborador').value ="";
    document.querySelector('.modal-header').classList.replace("headerUpdate", "headerRegister");
    document.querySelector('#btnActionForm').classList.replace("btn-info", "btn-primary");
    document.querySelector('#btnText').innerHTML ="Guardar";
    document.querySelector('#titleModal').innerHTML = "Nuevo Colaborador";
    document.querySelector("#formColaborador").reset();
    $('#modalFormColaborador').modal('show');
}