<?php 

	class FuentesHallazgo extends Controllers{
		public function __construct()
		{
			parent::__construct();
			session_start();
			session_regenerate_id(true);
			if(empty($_SESSION['login']))
			{
				header('Location: '.base_url_proyecto().'/login');
				die();
			}
			getPermisos(2);
		}

		public function FuentesHallazgo()
		{
			if(empty($_SESSION['permisosMod']['r'])){
				header("Location:".base_url_proyecto().'/dashboard');
			}
			$data['page_tag'] = "Fuentes Hallazgo";
			$data['page_title'] = "FUENTES HALLAZGO <small>Plataforma E-Hallazgos</small>";
			$data['page_name'] = "fuenteshallazgo";
			$data['page_functions_js'] = "functions_fuenteshallazgo.js";
			$this->views->getView($this,"fuenteshallazgo",$data);
		}

		public function setFuenteHallazgo()
		{
			if($_POST)
			{			
				if(empty($_POST['txtNombre']))
				{
					$arrResponse = array("status" => false, "msg" => 'Datos incorrectos.');
				}
				else
				{ 
					$intIdfuentehallazgo = ucwords(strClean($_POST['idFuenteHallazgo']));
					$strNombre = ucwords(strClean($_POST['txtNombre']));
					
					$request_fuentehallazgo = "";		
					if($intIdfuentehallazgo == 0)
					{
						$option = 1;						
						if($_SESSION['permisosMod']['w']){
							$request_fuentehallazgo = $this->model->insertFuenteHallazgo($strNombre);
						}
					}else{
						$option = 2;
						if($_SESSION['permisosMod']['u']){
							$request_fuentehallazgo = $this->model->updateFuenteHallazgo($intIdfuentehallazgo,$strNombre);
						}

					}
				}

				if($request_fuentehallazgo > 0 )
				{
						if($option == 1)
						{
							$arrResponse = array('status' => true, 'msg' => 'Datos guardados correctamente.');
						}
						else
						{
							$arrResponse = array('status' => true, 'msg' => 'Datos Actualizados correctamente.');
						}
				}
				else if($request_fuentehallazgo == 'exist')
				{
						$arrResponse = array('status' => false, 'msg' => '¡Atención! la fuente de hallazgo ya existe, ingrese otra.');		
				}
				else
				{
						$arrResponse = array("status" => false, "msg" => 'No es posible almacenar los datos.');
				}
				echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
			}
			die();
		}

		public function getFuentesHallazgo()
		{
			if($_SESSION['permisosMod']['r']){
				$arrData = $this->model->selectFuentesHallazgo();
				for ($i=0; $i < count($arrData); $i++) {
					$btnView = '';
					$btnEdit = '';
					$btnDelete = '';

					
					if($_SESSION['permisosMod']['u']){
						if(($_SESSION['idUser'] == 1 and $_SESSION['userData']['idrol'] == 1) ||
							$_SESSION['userData']['idrol'] == 1 ){
							$btnEdit = '<button class="btn btn-primary  btn-sm btnEditFuenteHallazgo" onClick="fntEditFuenteHallazgo(this,'.$arrData[$i]['id_fuente_no_conformidad'].')" title="Editar fuente hallazgo"><i class="fas fa-pencil-alt"></i></button>';
						}else{
							$btnEdit = '<button class="btn btn-secondary btn-sm" disabled ><i class="fas fa-pencil-alt"></i></button>';
						}
					}
					if($_SESSION['permisosMod']['d']){
						if(($_SESSION['idUser'] == 1 and $_SESSION['userData']['idrol'] == 1) ||
							($_SESSION['userData']['idrol'] == 1 )  ){
							$parametro1 = $arrData[$i]['id_fuente_no_conformidad'];
							$parametro2 = "'".$arrData[$i]['nombre']."'";
							$btnDelete = '<button class="btn btn-danger btn-sm btnDelFuenteHallazgo" 
							onClick="fntDelFuenteHallazgo('.$parametro1.",".$parametro2.')" title="Eliminar fuente de hallazgo"><i class="far fa-trash-alt"></i></button>';
						}else{
							$btnDelete = '<button class="btn btn-secondary btn-sm" disabled ><i class="far fa-trash-alt"></i></button>';
						}
					}
					$arrData[$i]['options'] = '<div class="text-center">'.$btnView.' '.$btnEdit.' '.$btnDelete.'</div>';
				}
				echo json_encode($arrData,JSON_UNESCAPED_UNICODE);
			}
			die();
		}


		public function getSelectFuentesHallazgo()
		{
			$htmlOptions = "";
			$arrData = $this->model->selectFuentesHallazgo();			
			if(count($arrData) > 0 ){
				for ($i=0; $i < count($arrData); $i++) { 					
					$htmlOptions .= '<option value="'.$arrData[$i]['id_fuente_no_conformidad'].'">'.$arrData[$i]['nombre'].'</option>';					
				}
			}
			echo $htmlOptions;
			die();		
		}

		public function getFuenteHallazgo($idfuentehallazgo){
			if($_SESSION['permisosMod']['r']){
				$idfuentehallazgo = intval($idfuentehallazgo);
				if($idfuentehallazgo > 0)
				{
					$arrData = $this->model->selectFuenteHallazgo($idfuentehallazgo);
					
					if(empty($arrData))
					{
						$arrResponse = array('status' => false, 'msg' => 'Datos no encontrados.');
					}else{
						$arrResponse = array('status' => true, 'data' => $arrData);
					}
					echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
				}
			}
			die();
		}

		public function delFuenteHallazgo()
		{
			if($_POST){
				if($_SESSION['permisosMod']['d']){
					$idfuentehallazgo = intval($_POST['idfuentehallazgo']);

					$requestDelete = $this->model->deleteFuenteHallazgo($idfuentehallazgo);
					if($requestDelete)
					{
						$arrResponse = array('status' => true, 'msg' => 'Fuente de hallazgo eliminada exitosamente');
					}else{
						$arrResponse = array('status' => false, 'msg' => 'Error al eliminar la fuente de hallazgo');
					}
					echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
				}
			}
			die();
		}
	}
 ?>