<?php 

	class Lugares extends Controllers{
		public function __construct()
		{
			parent::__construct();
			session_start();
			session_regenerate_id(true);
			if(empty($_SESSION['login']))
			{
				header('Location: '.base_url_proyecto().'/login');
				die();
			}
			getPermisos(2);
		}

		public function Lugares()
		{
			if(empty($_SESSION['permisosMod']['r'])){
				header("Location:".base_url_proyecto().'/dashboard');
			}
			$data['page_tag'] = "Lugares";
			$data['page_title'] = "LUGARES <small>Plataforma E-Hallazgos</small>";
			$data['page_name'] = "lugares";
			$data['page_functions_js'] = "functions_lugares.js";
			$this->views->getView($this,"lugares",$data);
		}

		public function setLugar()
		{
			if($_POST)
			{			
				if(empty($_POST['txtNombre']))
				{
					$arrResponse = array("status" => false, "msg" => 'Datos incorrectos.');
				}
				else
				{ 
					$intIdlugar = ucwords(strClean($_POST['idLugar']));
					$strNombre = ucwords(strClean($_POST['txtNombre']));
					
					$request_lugar = "";		
					if($intIdlugar == 0)
					{
						$option = 1;						
						if($_SESSION['permisosMod']['w']){
							$request_lugar = $this->model->insertLugar($strNombre);
						}
					}else{
						$option = 2;
						if($_SESSION['permisosMod']['u']){
							$request_lugar = $this->model->updateLugar($intIdlugar,$strNombre);
						}

					}
				}

				if($request_lugar > 0 )
				{
						if($option == 1)
						{
							$arrResponse = array('status' => true, 'msg' => 'Datos guardados correctamente.');
						}
						else
						{
							$arrResponse = array('status' => true, 'msg' => 'Datos Actualizados correctamente.');
						}
				}
				else if($request_lugar == 'exist')
				{
						$arrResponse = array('status' => false, 'msg' => '¡Atención! el Lugar ya existe, ingrese otro.');		
				}
				else
				{
						$arrResponse = array("status" => false, "msg" => 'No es posible almacenar los datos.');
				}
				echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
			}
			die();
		}

		public function getLugares()
		{
			if($_SESSION['permisosMod']['r']){
				$arrData = $this->model->selectLugares();
				for ($i=0; $i < count($arrData); $i++) {
					$btnView = '';
					$btnEdit = '';
					$btnDelete = '';

					
					if($_SESSION['permisosMod']['u']){
						if(($_SESSION['idUser'] == 1 and $_SESSION['userData']['idrol'] == 1) ||
							$_SESSION['userData']['idrol'] == 1 ){
							$btnEdit = '<button class="btn btn-primary  btn-sm btnEditLugar" onClick="fntEditLugar(this,'.$arrData[$i]['id_sucursal'].')" title="Editar lugar"><i class="fas fa-pencil-alt"></i></button>';
						}else{
							$btnEdit = '<button class="btn btn-secondary btn-sm" disabled ><i class="fas fa-pencil-alt"></i></button>';
						}
					}
					if($_SESSION['permisosMod']['d']){
						if(($_SESSION['idUser'] == 1 and $_SESSION['userData']['idrol'] == 1) ||
							($_SESSION['userData']['idrol'] == 1 )  ){
							$parametro1 = $arrData[$i]['id_sucursal'];
							$parametro2 = "'".$arrData[$i]['descripcion']."'";
							$btnDelete = '<button class="btn btn-danger btn-sm btnDelLugar" 
							onClick="fntDelLugar('.$parametro1.",".$parametro2.')" title="Eliminar lugar"><i class="far fa-trash-alt"></i></button>';
						}else{
							$btnDelete = '<button class="btn btn-secondary btn-sm" disabled ><i class="far fa-trash-alt"></i></button>';
						}
					}
					$arrData[$i]['options'] = '<div class="text-center">'.$btnView.' '.$btnEdit.' '.$btnDelete.'</div>';
				}
				echo json_encode($arrData,JSON_UNESCAPED_UNICODE);
			}
			die();
		}

		public function getSelectLugares()
		{
			$htmlOptions = "";
			$arrData = $this->model->selectLugares();			
			if(count($arrData) > 0 ){
				for ($i=0; $i < count($arrData); $i++) { 					
					$htmlOptions .= '<option value="'.$arrData[$i]['id_sucursal'].'">'.$arrData[$i]['descripcion'].'</option>';					
				}
			}
			echo $htmlOptions;
			die();		
		}

		public function getLugar($idlugar){
			if($_SESSION['permisosMod']['r']){
				$idlugar = intval($idlugar);
				if($idlugar > 0)
				{
					$arrData = $this->model->selectLugar($idlugar);
					
					if(empty($arrData))
					{
						$arrResponse = array('status' => false, 'msg' => 'Datos no encontrados.');
					}else{
						$arrResponse = array('status' => true, 'data' => $arrData);
					}
					echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
				}
			}
			die();
		}

		public function delLugar()
		{
			if($_POST){
				if($_SESSION['permisosMod']['d']){
					$idlugar = intval($_POST['idLugar']);

					$requestDelete = $this->model->deleteLugar($idlugar);
					if($requestDelete)
					{
						$arrResponse = array('status' => true, 'msg' => 'Lugar eliminado exitosamente');
					}else{
						$arrResponse = array('status' => false, 'msg' => 'Error al eliminar el lugar');
					}
					echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
				}
			}
			die();
		}
	}
 ?>