<?php 

	class HallazgosModel extends Mysql
	{
		private $intIdHallazgo;		
		private $intIdObra;
		private $strFecha;
		private $strArea;
		private $intIdempleado;
		private $strSupervisorArea;
		private $strCargo;
		private $intFlash;
		private $intIdTipoHallazgo;
		private $strDescripcion;
		private $strAccionInmediata;
		private $strAnalisis;
		private $strSeguimiento;
		private $intIdUsuario;
		private $strFechaSistema;
		private $intIdEstadoHallazgo;
		private $intIdFuenteNoConformidad;
		private $intIdAmbitoHallazgo;
		private $strFechaCierre;
		private $strEvidenciaCierre;
		private $strPlanAccion;
		private $intIdResponsableCierre;
		private $strFechaAnulacion;
		private $intIdResponsableAnulacion;
		private $intIdResponsableAnalisisCausal;
		private $intEvaluacionEficacia;
		private $strDigitadopor;
		private $intIdTipoAccion;
		private $strComentario;

		private $strRuta;
		private $strImagen;

		public function __construct()
		{
			parent::__construct();
		}

		public function selectHallazgos(){
			$sql = "SELECT h.id_hallazgo, h.fecha, h.descripcion, h.id_estado_hallazgo, t.descripcion as nombretipohallazgo, c.descripcion as lugarhallazgo, a.nombre as ambitohallazgo, f.nombre as fuentehallazgo, v.nombre_empleado as nombrereporta, v.apellido_empleado as apellidoreporta, u.nombre as nombredigita, u.apellido as apellidodigita, h.fecha_cierre
					FROM hallazgos h, ambitos a,  areas ar, fuente_no_conformidad f, tipos_hallazgos t, cont_sucursal c, vtaop_empleado v, cmn_usuario u
					WHERE  h.id_ambito_hallazgo = a.id_ambito_hallazgo 
					AND h.area = ar.id_area
					AND h.id_fuente_no_conformidad = f.id_fuente_no_conformidad
					AND h.id_tipo_hallazgo = t.id_tipo_hallazgo
					AND h.id_obra = c.id_sucursal
					AND h.id_usuario = u.id_usuario
					AND h.empleado = v.id_empleado";
					
					$request = $this->select_all($sql);
					
			return $request;
		}	


		public function insertHallazgo(string $fecha, int $id_obra, int $area, int $empleado, int $id_fuente_no_conformidad, int $id_ambito_hallazgo, int $id_tipo_hallazgo, string $descripcion, string $accion_inmediata, string $analisis,  string $comentario, int $id_responsable_analisis_causal, int $intFlash)
		{
			$this->strFecha = $fecha;
			$this->intIdObra = $id_obra;
			$this->intArea = $area;
			$this->intIdempleado = $empleado;
			$this->intIdFuenteNoConformidad = $id_fuente_no_conformidad;
			$this->intIdAmbitoHallazgo = $id_ambito_hallazgo;
			$this->intIdTipoHallazgo = $id_tipo_hallazgo;
			$this->strDescripcion = $descripcion;
			$this->strAccionInmediata = $accion_inmediata;
			$this->strAnalisis = $analisis;
			$this->strComentario = $comentario;			
			$this->intIdResponsableAnalisisCausal = $id_responsable_analisis_causal;			
			$this->intIdUsuario = $_SESSION['idUser'];
			$this->strFechaSistema = date("YmdHi");
			$this->intIdEstadoHallazgo = 3; // Abierto
			$this->intFlash = $intFlash;
			$return = 0;
			$query_insert  = "INSERT INTO hallazgos(id_obra, 
													fecha, 
													area, 
													empleado, 
													id_fuente_no_conformidad, 
													id_ambito_hallazgo, 
													id_tipo_hallazgo, 													
													descripcion, 
													accion_inmediata,
													analisis, 
													comentario,
													id_responsable_analisis_causal,												
													id_usuario, 
													fecha_sistema, 
													id_estado_hallazgo,
													flash)
								  VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";

								  
	        	$arrData = array($this->intIdObra,
        						$this->strFecha,
        						$this->intArea,
        						$this->intIdempleado,
        						$this->intIdFuenteNoConformidad,
        						$this->intIdAmbitoHallazgo,
        						$this->intIdTipoHallazgo,
								$this->strDescripcion,
								$this->strAccionInmediata,
								$this->strAnalisis,
								$this->strComentario,
								$this->intIdResponsableAnalisisCausal,	       					
	       						$this->intIdUsuario,
	       						$this->strFechaSistema,
	       						$this->intIdEstadoHallazgo,
	       						$this->intFlash);

	        	$request_insert = $this->insert($query_insert,$arrData);
	        	$return = $request_insert;
			
	        return $return;
		}


		public function updateHallazgo(int $id_hallazgo, id_string $fecha, int $id_obra, int $area, int $empleado, int $id_fuente_no_conformidad, int $id_ambito_hallazgo, int $id_tipo_hallazgo, string $descripcion, string $accion_inmediata, string $analisis,  string $comentario, int $id_responsable_analisis_causal, int $flash, int $evaluacion_eficacia, str $seguimiento, int $id_estado_hallazgo){
			
			
			$this->strFecha = $fecha;
			$this->strDescripcion = $descripcion;
			$this->strAnalisis = $analisis;
			$this->strAccionInmediata = $accion_inmediata;
			$this->strSeguimiento = $seguimiento;			
			$this->strFechaCierre = $fecha_cierre;
			$this->strEvidenciaCierre = $evidencia_cierre;
			$this->strPlanAccion = $plan_accion;
			$this->strFechaAnulacion = $fecha_anulacion;			
			$this->strComentario = $comentario;

			$this->intIdHallazgo = $id_hallazgo;
			$this->intIdObra = $id_obra;
			$this->intArea = $area;
			$this->intIdempleado = $empleado;
			$this->intFlash = $flash;
			$this->intIdTipoHallazgo = $id_tipo_hallazgo;			
			$this->intIdEstadoHallazgo = $id_estado_hallazgo;
			$this->intIdFuenteNoConformidad = $id_fuente_no_conformidad;
			$this->intIdAmbitoHallazgo = $id_ambito_hallazgo;
			$this->intIdResponsableCierre = $id_responsable_cierre;
			$this->intIdResponsableAnulacion = $id_responsable_anulacion;
			$this->intIdResponsableAnalisisCausal = $id_responsable_analisis_causal;
			$this->intEvaluacionEficacia = $evaluacion_eficacia;
			$return = 0;
			

			$sql = "UPDATE hallazgos 
						SET idobra=?, 
							fecha=?, 
							area=?, 
							empleado=?, 
							supervisor_area=?, 
							cargo=?, 
							flash=?, 
							id_tipo_hallazgo=?, 
							descripcion=?, 
							analisis=?, 
							accion_inmediata=?, 
							seguimiento=?, 														
							id_estado_hallazgo=?, 
							id_fuente_no_conformidad=?, 
							id_ambito_hallazgo=?, 
							fecha_cierre=?, 
							evidencia_cierre=?, 
							plan_accion=?, 
							id_responsable_cierre=?, 
							fecha_anulacion=?, 
							id_responsable_anulacion=?,
							id_responsable_analisis_causal=?, 
							evaluacion_eficacia=?, 							
							id_tipo_accion=?, 
							comentario=?						
						WHERE id_hallazgo = $this->intIdHallazgo ";

			$arrData = array($this->intIdObra,
        						$this->strFecha,
        						$this->intArea,
        						$this->intIdempleado,
        						$this->strSupervisorArea,
        						$this->strCargo,
        						$this->intFlash,
        						$this->intIdTipoHallazgo,
        						$this->strDescripcion,
        						$this->strAnalisis,
        						$this->strAccionInmediata,
        						$this->strSeguimiento,        						
        						$this->intIdEstadoHallazgo,
        						$this->intIdFuenteNoConformidad,
        						$this->intIdAmbitoHallazgo,
        						$this->strFechaCierre,
        						$this->strEvidenciaCierre,
        						$this->strPlanAccion,
        						$this->intIdResponsableCierre,
        						$this->strFechaAnulacion,
        						$this->intIdResponsableAnulacion,
        						$this->intIdResponsableAnalisisCausal,        						
        						$this->intEvaluacionEficacia,
        						$this->intIdTipoAccion,
        						$this->strComentario);
	        $request = $this->update($sql,$arrData);
	        $return = $request;
			
	        
		}

		public function selectHallazgo(int $idhallazgo){
			$this->intIdHallazgo = $idhallazgo;
			$sql = "SELECT h.*, t.descripcion as nombretipohallazgo, c.descripcion as lugarhallazgo, a.nombre as ambitohallazgo, f.nombre as fuentehallazgo, v.nombre_empleado as nombrereporta, v.apellido_empleado as apellidoreporta 
					FROM hallazgos h, ambitos a,  areas ar, fuente_no_conformidad f, tipos_hallazgos t, cont_sucursal c, vtaop_empleado v, cmn_usuario u
					WHERE  h.id_ambito_hallazgo = a.id_ambito_hallazgo 
					AND h.area = ar.id_area
					AND h.id_fuente_no_conformidad = f.id_fuente_no_conformidad
					AND h.id_tipo_hallazgo = t.id_tipo_hallazgo
					AND h.id_obra = c.id_sucursal
					AND h.empleado = v.id_empleado
					AND h.id_usuario = u.id_usuario
					AND h.id_hallazgo = $this->intIdHallazgo";
					
			$request = $this->select($sql);
			return $request;

		}

		public function insertImage(int $idhallazgo, string $imagen){
			$this->intIdHallazgo = $idhallazgo;
			$this->strImagen = $imagen;
			$query_insert  = "INSERT INTO imagen(productoid,img) VALUES(?,?)";
	        $arrData = array($this->intIdHallazgo,
        					$this->strImagen);
	        $request_insert = $this->insert($query_insert,$arrData);
	        return $request_insert;
		}

		public function selectImages(int $idhallazgo){
			$this->intIdHallazgo = $idhallazgo;
			$sql = "SELECT productoid,img
					FROM imagen
					WHERE productoid = $this->intIdHallazgo";
			$request = $this->select_all($sql);
			return $request;
		}

		public function deleteImage(int $idhallazgo, string $imagen){
			$this->intIdHallazgo = $idhallazgo;
			$this->strImagen = $imagen;
			$query  = "DELETE FROM imagen 
						WHERE productoid = $this->intIdHallazgo 
						AND img = '{$this->strImagen}'";
	        $request_delete = $this->delete($query);
	        return $request_delete;
		}

		public function updateImage(int $idhallazgo){
			$this->intIdHallazgo = $idhallazgo;
			
			$query  = "UPDATE imagen 
						SET productoid = ". $this->intIdHallazgo.
						" WHERE productoid = ". $_SESSION['idUser'];
			
	        $request_update = $this->delete($query);
	        return $request_update;
		}


		public function deleteHallazgo(int $idhallazgo){
			$this->intIdHallazgo = $idhallazgo;
			$sql = "UPDATE hallazgos SET id_estado_hallazgo = ? WHERE idhallazgo = $this->intIdHallazgo ";
			$arrData = array(0);
			$request = $this->update($sql,$arrData);
			return $request;
		}


	}
 ?>