<?php 
headerAdmin($data); 
$hoy = date("Y-m-d");
$fecha_inicial = date('Y-m-01');  
?>
<main class="app-content">
  <div class="app-title">
    <div>
      <h1><i class="fa fa-dashboard"></i><?= $data['page_title'] ?></h1>
    </div>
    <ul class="app-breadcrumb breadcrumb">
      <li class="breadcrumb-item"><i class="fa fa-home fa-lg"></i></li>
      <li class="breadcrumb-item"><a href="<?= base_url_proyecto(); ?>/dashboard">Dashboard</a></li>
    </ul>
  </div>
  <div class="row">
    <?php if(!empty($_SESSION['permisos'][2]['r'])){ ?>
      <div class="col-md-6 col-lg-3">
        <a href="<?= base_url_proyecto() ?>/hallazgos" class="linkw">
          <div class="widget-small primary coloured-icon"><i class="icon fa fa-users fa-3x"></i>
            <div class="info">
              <h4>Hallazgos abiertos</h4>
              <p><b><?= $data['hallazgosabiertos'] ?></b></p>
            </div>
          </div>
        </a>
      </div>
    <?php } ?>
    <?php if(!empty($_SESSION['permisos'][3]['r'])){ ?>
      <div class="col-md-6 col-lg-3">
        <a href="<?= base_url_proyecto() ?>/hallazgos" class="linkw">
          <div class="widget-small info coloured-icon"><i class="icon fa fa-user fa-3x"></i>
            <div class="info">
              <h4>Hallazgos cerrados</h4>
              <p><b><?= $data['hallazgoscerrados'] ?></b></p>
            </div>
          </div>
        </a>
      </div>
    <?php } ?>
    <?php if(!empty($_SESSION['permisos'][4]['r']) ){ ?>
      <div class="col-md-6 col-lg-3">
        <a href="<?= base_url_proyecto() ?>/hallazgos" class="linkw">
          <div class="widget-small warning coloured-icon"><i class="icon fa fa fa-archive fa-3x"></i>
            <div class="info">
              <h4>Hallazgos nulos</h4>
              <p><b><?= $data['hallazgosnulos'] ?></b></p>
            </div>
          </div>
        </a>
      </div>
    <?php } ?>
    <?php if(!empty($_SESSION['permisos'][5]['r'])){ ?>
      <div class="col-md-6 col-lg-3">
        <a href="<?= base_url_proyecto() ?>/hallazgos" class="linkw">
          <div class="widget-small danger coloured-icon"><i class="icon fa fa-shopping-cart fa-3x"></i>
            <div class="info">
              <h4>Total hallazgos</h4>
              <p><b><?= $data['hallazgostotal'] ?></b></p>
            </div>
          </div>
        </a>
      </div>
    <?php } ?>
  </div>
  <div class="row">
    <div class="col-md-6">
      <div class="tile">
        <div class="container-title">
          <h3 class="tile-title">Hallazgos por colaborador </h3>
          <div class="dflex" align=right>                              
            <input type="date" class="form-control fecha_ini"  name="fecha_ini" id="fecha_ini" value="<?php echo $fecha_inicial?>">
            <input type="date" class="form-control fecha_fin"  name="fecha_fin" id="fecha_fin" value="<?php echo $hoy?>">
            <select class="form-control tipografico" name="tipografico" id="tipografico" onchange="fntSearchHallazgosColaborador()">
              <option value="pie" selected>Pie (Porcentaje)</option>                        
              <option value="column">Barras (Cantidad)</option>                                                
            </select>
            <button type="button" class="btn btn-info btn-sm" onclick="fntSearchHallazgosColaborador()"> <i class="fas fa-search"></i> </button>

          </div>

        </div>
        <div id="graficoporcolaboradores"></div>
      </div>
    </div>
    <div class="col-md-6">
      <div class="tile">
        <div class="container-title">
          <h3 class="tile-title">Hallazgos por área</h3>
          <div class="dflex" align=right>                              
            <input type="date" class="form-control fecha_ini_area"  name="fecha_ini_area" id="fecha_ini_area" value="<?php echo $fecha_inicial?>">
            <input type="date" class="form-control fecha_fin_area"  name="fecha_fin_area" id="fecha_fin_area" value="<?php echo $hoy?>">
            <select class="form-control tipografico_area" name="tipografico_area" id="tipografico_area" onchange="fntSearchHallazgosArea()">
              <option value="pie" selected>Pie (Porcentaje)</option>                        
              <option value="column">Barras (Cantidad)</option>                                                
            </select>
            <button type="button" class="btn btn-info btn-sm" onclick="fntSearchHallazgosArea()"> <i class="fas fa-search"></i> </button>
          </div>
        </div>
        <div id="graficoporareas"></div>
      </div>
    </div>
  </div>  
  <div class="row">
    <div class="col-md-4">
      <div class="tile">
        <div class="container-title">
          <h3 class="tile-title">Hallazgos por Tipo</h3>
          <div class="dflex" align=right>                              
            <input type="date" class="form-control fecha_ini_tipo"  name="fecha_ini_tipo" id="fecha_ini_tipo" value="<?php echo $fecha_inicial?>">
            <input type="date" class="form-control fecha_fin_tipo"  name="fecha_fin_tipo" id="fecha_fin_tipo" value="<?php echo $hoy?>">
            <select class="form-control tipografico_tipo" name="tipografico_tipo" id="tipografico_tipo" onchange="fntSearchHallazgosTipo()">
              <option value="pie" selected>Pie (Porcentaje)</option>                        
              <option value="column">Barras (Cantidad)</option>                                                
            </select>
            <button type="button" class="btn btn-info btn-sm" onclick="fntSearchHallazgosTipo()"> <i class="fas fa-search"></i> </button>
          </div>
        </div>
        <div id="graficoportipos"></div>
      </div>
    </div>
    <div class="col-md-4">
      <div class="tile">
        <div class="container-title">
          <h3 class="tile-title">Hallazgos por Ámbito</h3>
          <div class="dflex" align=right>                              
            <input type="date" class="form-control fecha_ini_ambito"  name="fecha_ini_ambito" id="fecha_ini_ambito" value="<?php echo $fecha_inicial?>">
            <input type="date" class="form-control fecha_fin_ambito"  name="fecha_fin_ambito" id="fecha_fin_ambito" value="<?php echo $hoy?>">
            <select class="form-control tipografico_ambito" name="tipografico_ambito" id="tipografico_ambito" onchange="fntSearchHallazgosAmbito()">
              <option value="pie" selected>Pie (Porcentaje)</option>                        
              <option value="column">Barras (Cantidad)</option>                                                
            </select>
            <button type="button" class="btn btn-info btn-sm" onclick="fntSearchHallazgosAmbito()"> <i class="fas fa-search"></i> </button>
          </div>
        </div>
        <div id="graficoporambitos"></div>
      </div>
    </div>
  <div class="col-md-4">
    <div class="tile">
      <div class="container-title">
        <h3 class="tile-title">Hallazgos por Fuente</h3>
        <div class="dflex" align=right>                              
          <input type="date" class="form-control fecha_ini_fuente"  name="fecha_ini_fuente" id="fecha_ini_fuente" value="<?php echo $fecha_inicial?>">
          <input type="date" class="form-control fecha_fin_fuente"  name="fecha_fin_fuente" id="fecha_fin_fuente" value="<?php echo $hoy?>">
          <select class="form-control tipografico_fuente" name="tipografico_fuente" id="tipografico_fuente" onchange="fntSearchHallazgosFuente()">
            <option value="pie" selected>Pie (Porcentaje)</option>                        
            <option value="column">Barras (Cantidad)</option>                                                
          </select>
          <button type="button" class="btn btn-info btn-sm" onclick="fntSearchHallazgosFuente()"> <i class="fas fa-search"></i> </button>
        </div>
      </div>
      <div id="graficoporfuentes"></div>
    </div>
  </div>
</div>
</div>
<div class="row">
  <?php if(!empty($_SESSION['permisos'][4]['r'])){ ?>
    <div class="col-md-12">
      <div class="tile">
        <h3 class="tile-title">Últimos Hallazgos</h3>
        <table class="table table-striped table-sm">
          <thead>
            <tr>
              <th>#</th>
              <th>Fecha creación</th>                
              <th>Área</th>
              <th>Fuente</th>
              <th>Ámbito</th>
              <th>Tipo</th>
              <th>Descripción</th>
              <th>Reporta</th>
              <th>Análisis causal</th>
              <th>Fecha cierre</th>
              <th>Estado</th>
              <th></th>
            </tr>
          </thead>
          <tbody>
            <?php               
            foreach ($data['lastHallazgos'] as $hallazgo) {
             ?>
             <tr>
              <td><?= $hallazgo['id_hallazgo'] ?><a href="<?= base_url_proyecto() ?>hallazgos/hallazgo/<?= $hallazgo['id_hallazgo'] ?>" target="_blank"><i class="fa fa-eye" aria-hidden="true"></i></a></td>                  
              <td class="text-center"><?= ConvertirFechaBD_fecha($hallazgo['fecha']) ?></td>                  
              <td class="text-left"><?= $hallazgo['nombre_area'] ?></td>
              <td class="text-left"><?= $hallazgo['nombre_fuente'] ?></td>
              <td class="text-left"><?= $hallazgo['nombre_ambito'] ?></td>
              <td class="text-left"><?= $hallazgo['nombre_tipo'] ?></td>
              <td class="text-left"><?= $hallazgo['descripcion'] ?></td>
              <td class="text-left"><?= $hallazgo['nombre_colaborador'] ?></td>
              <td class="text-left"><?= $hallazgo['nombre_colaborador'] ?></td>                  
              <td class="text-center"><?= ConvertirFechaBD_fecha($hallazgo['fecha_cierre']) ?></td>                  
              <td class="text-left"><?= $hallazgo['nombre_estado'] ?></td>
            </tr>
            <?php 
          } ?>
        </tbody>
      </table>
    </div>
  </div>
<?php } ?>
</div>  
</main>
</div>

<?php footerAdmin($data); ?>

